/*
 * Decompiled with CFR 0.152.
 */
package io.neox.neonium;

import io.neox.neonium.LittleTilesCompat;
import io.neox.neonium.VeryEarlyModDetector;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.common.config.EarlyModDetection;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="neonium", name="Neonium", version="1.1.3", clientSideOnly=true)
public class Neonium {
    public static final String MODID = "neonium";
    public static final String MODNAME = "Neonium";
    public static final String VERSION = "1.1.3";
    public static final String MOD_VERSION = "1.1.3";
    private static SodiumGameOptions CONFIG;
    public static Logger LOGGER;
    public static Neonium INSTANCE;

    public Neonium() {
        INSTANCE = this;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("Initializing Neonium 1.1.3");
        boolean isLittleTiles = LittleTilesCompat.isLittleTilesLoaded();
        EarlyModDetection.setLittleTilesPresent(isLittleTiles);
        if (isLittleTiles) {
            LOGGER.info("LittleTiles detected in preInit - compatibility mode will be used");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        boolean isLittleTiles = VeryEarlyModDetector.isLittleTilesPresent();
        EarlyModDetection.setLittleTilesPresent(isLittleTiles);
        if (isLittleTiles) {
            LOGGER.info("LittleTiles detected in construction - compatibility mode will be used");
        }
    }

    public static SodiumGameOptions options() {
        if (CONFIG == null) {
            CONFIG = Neonium.loadConfig();
        }
        return CONFIG;
    }

    public static Logger logger() {
        if (LOGGER == null) {
            LOGGER = LogManager.getLogger((String)MODNAME);
        }
        return LOGGER;
    }

    private static SodiumGameOptions loadConfig() {
        return SodiumGameOptions.load(Minecraft.func_71410_x().field_71412_D.toPath().resolve("config").resolve("neonium-options.json"));
    }

    public static String getVersion() {
        return "1.1.3";
    }

    public static boolean isDirectMemoryAccessEnabled() {
        return Neonium.options().advanced.allowDirectMemoryAccess;
    }

    static {
        LOGGER = LogManager.getLogger((String)MODNAME);
        boolean isLittleTilesPresent = VeryEarlyModDetector.isLittleTilesPresent();
        System.out.println("[Neonium] Static initializer: LittleTiles detection = " + isLittleTilesPresent);
        try {
            EarlyModDetection.setLittleTilesPresent(isLittleTilesPresent);
        }
        catch (Throwable t) {
            System.err.println("[Neonium] Error updating early detection: " + t.getMessage());
        }
    }
}

